IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CF_Percep_IIBB_Entrerios_TX') 
                   and type = 'FN')
BEGIN
    DROP FUNCTION dbo.CF_Percep_IIBB_Entrerios_TX
END
GO
CREATE FUNCTION [dbo].[CF_Percep_IIBB_Entrerios_TX](@pId_Trans INT, @pId_Tipo_Reten VARCHAR(10), @pNroRenglon INT) 
RETURNS CHAR(140)
AS
BEGIN

DECLARE @Retorno			CHAR(140)
/*Formato segun ticket 004984*/
DECLARE @aNroRenglon		CHAR(5)		/*Formato: 99999 Creciente */
DECLARE @aFecha				CHAR(10)	/*Formato: ddmmaaaa*/
DECLARE @aTipoCbte			CHAR(3)		/*Formato: Ver lista abajo*/
DECLARE @aSucursal			CHAR(4)		/*Punto de Venta*/
DECLARE @aNroCbte			CHAR(8)		/*Formato: Ceros a la izquierda */
DECLARE @aNombre			CHAR(60)	/*Formato: Blancos a la derecha*/
DECLARE @aCUIT				CHAR(11)	/*Formato: 99999999999*/
DECLARE @aMonto				CHAR(10)	/*Formato: -999999999999.99 (no se aclara para este campo pero se supone que puede ser negativo sino no seria 16*/
DECLARE @aAlicuota			CHAR(4)		/*Formato: 99.99*/
DECLARE @aImporte			CHAR(10)	/*Formato: -999999999999.99 (Signo negativo a la izq en caso de indicar un Comprobante tipo Nota de Credito*/
DECLARE @aCodCM				CHAR(3)		/*Formato: 908 Codigo Convenio multilateral DDJJ */		
DECLARE @aTipoPercepcion    CHAR(3)		/* Regin de Percepcion segun la juridiccion 011*/
DECLARE @aSeparador			CHAR(1)     /*delimitador de campos*/


DECLARE @Id_Tipo_Cbte		CHAR(4)
DECLARE @Fecha				DATETIME
DECLARE @Id_Sucursal		SMALLINT
DECLARE @Comprobante_Nro	INT
DECLARE @Destinatario		VARCHAR(100)
DECLARE @Compromete_Factura	SMALLINT
DECLARE @Letra				CHAR(1)
DECLARE @Id_Triburario		VARCHAR(4)
DECLARE @Cuit				VARCHAR(11)
DECLARE @Imp_Total			DECIMAL(12,2)
DECLARE @Importe			DECIMAL(12,2)
DECLARE @Porc				DECIMAL(7,4)
DECLARE @Id_Cliente			INT
DECLARE @compromete_Recibo	SMALLINT
DECLARE @Imp_Base_Imponible	DECIMAL(12,2)
DECLARE @Fecha_Perc			DATETIME
/*Tipos de Comprobantes*/
/*
 * 1: Factura A
 * 2: Nota de Debito
 * 3: Recibo NO tiene Codigo Tributario
 * 4: Nota de Venta de Contado codigo 10
 * 5: Factura de Exportación codigo 19
 * 6: Nota de Debito para operacion c/exterior codigo 20
 * 7: Liquidacion codigos 27,28,29
 * 20: Otros Comprobantes de Debito 
 * 102: Nota de Credito 3
 * 106: Nota de Crédito para operaciones c/exterior
 *120: Otros comprobantes de Credito codigo 21	
*/

SELECT	@Id_Tipo_Cbte		= ISNULL(Id_Tipo_Cbte, ''),
		@Fecha				= Fecha,
		@Id_Sucursal		= ISNULL(Id_Sucursal,0),
		@Comprobante_Nro	= ISNULL(Comprobante_Nro, 0),
		@Destinatario		= ISNULL(Destinatario, ''),
		@Id_Cliente			= ISNULL(Id_Cliente, 0),
		@Imp_Total			= ISNULL(Imp_Total, 0)
FROM Cbtes
WHERE
Id_Trans = @pId_Trans
AND Id_Estado_Cbte <> 3

SELECT	@Compromete_Factura = ISNULL(Compromete_Factura, 0),
		@compromete_Recibo	= ISNULL(@compromete_Recibo,0),
		@Letra				= ISNULL(Letra, ''),
		@Id_Triburario		= ISNULL(Id_Tributario, '')
FROM Cbtes_Tipos
WHERE
Id_Tipo_Cbte = @Id_Tipo_Cbte

SET @Cuit = (SELECT ISNULL(Cuit, '') FROM Clientes WHERE Id_Cliente = @Id_Cliente)

SELECT	@Importe			= ISNULL(CR.Importe, 0),
		@Porc				= ISNULL(CR.Porc, 0),
		@Imp_Base_Imponible = ISNULL(CR.Imp_Base_Imponible, 0),
		@Fecha_Perc			= Fecha
FROM Cbtes_Reten CR, Cbtes_Reten_Tipos CRT
WHERE
CR.Id_Tipo_Reten = CRT.Id_Tipo_Reten
AND CR.Id_Trans = @pId_Trans
AND ISNULL(CRT.Tipo, '') = 'P'
AND ISNULL(CRT.Tipo_Imp, '') = 'B'
AND ISNULL(CR.Importe, 0) <> 0
AND CR.Id_Tipo_Reten = @pId_Tipo_Reten


IF(@Id_Tipo_Cbte = '' OR @Id_Triburario = '' OR @Importe = 0)
BEGIN
	SET @Retorno = '                                                                                                                                            '
	RETURN @Retorno
END

/*Tipo Cbte*/
IF(@Id_Triburario IN ('01','06','11','201','206','211')) --1: Factura A
	SET @aTipoCbte = '001'

IF(@Id_Triburario IN ('2','02','07','12','202','207','212')) --Nota de Debito
	SET @aTipoCbte = '002'

/*Si es recibo No tiene Codigo Tributario X*/	
IF(@compromete_Recibo = 1)
	SET @aTipoCbte = '003'

IF(@Id_Triburario IN ('3','03','08','13','203','208','213')) --Nota de Credito
	SET @aTipoCbte = '102'

IF(@Id_Triburario = '10') --Nota de Venta de Contado
	SET @aTipoCbte = '004'
	
IF(@Id_Triburario = '19') --Factura de Exportación
	SET @aTipoCbte = '005'

IF(@Id_Triburario = '20') --Nota de Debito para operacion c/exterior
	SET @aTipoCbte = '006'
	
IF(@Id_Triburario IN ('27','28','29')) --Liquidación codigos 27,28,29
	SET @aTipoCbte = '007'

/*FIN Tipo Cbte*/	

SET @aSeparador		= ','
SET @aNroRenglon 	= RIGHT('00000' + CAST(@pNroRenglon as VARCHAR),5) 
--SET @aFecha			= RIGHT('00' + CAST(DAY(@Fecha) AS VARCHAR),2) + RIGHT('00' + CAST(MONTH(@Fecha) AS VARCHAR),2) + CAST(DATEPART(YY, @Fecha) AS CHAR(4))
SET @aFecha			= RIGHT('00' + CAST(DAY(@Fecha_Perc) AS VARCHAR),2) +
						'/' +
						RIGHT('00' + CAST(MONTH(@Fecha_Perc) AS VARCHAR),2) + 
						'/' +
						CAST(DATEPART(YY, @Fecha_Perc) AS CHAR(4))
SET @aSucursal		= RIGHT('0000' + CAST(@Id_Sucursal AS VARCHAR),4)
SET @aNroCbte		= RIGHT('00000000' + CAST(@Comprobante_Nro AS VARCHAR), 8)
SET @aNombre		= @Destinatario
SET @aCUIT			= @Cuit
SET @aCodCM			= '908'
SET @aTipoPercepcion = '001' /*Consultar el tipo de regimen para la juridiccion*/

IF(@aTipoCbte IN ('102', '106'))
BEGIN
	SET @aMonto		= '-' + RIGHT('0000000000' + CONVERT(VARCHAR(10), @Imp_Base_Imponible),10) 
	SET @aImporte	= '-' + RIGHT('0000000000' + CONVERT(VARCHAR(10), @Importe),10) 
END
ELSE
BEGIN
	SET @aMonto		= RIGHT('0000000000' + CONVERT(VARCHAR(10), @Imp_Base_Imponible),10) 
	SET @aImporte	= RIGHT('0000000000' + CONVERT(VARCHAR(10), @Importe),10) 
END

IF(@Porc >= 0.01)
BEGIN
	SET @aAlicuota = CAST(CONVERT(DECIMAL(7,2), @Porc) AS VARCHAR)
END
ELSE
BEGIN
	SET @aAlicuota = '0.01'
END

SET @Retorno	=	@aNroRenglon		+ @aSeparador +
					@aTipoCbte			+ @aSeparador +	
					@Letra				+ @aSeparador +
					@aSucursal			+
					@aNroCbte			+ @aSeparador +
					@aCUIT				+ @aSeparador +
					@aFecha				+ @aSeparador +
					@aMonto				+ @aSeparador +
					@aAlicuota			+ @aSeparador +
					@aImporte			+ @aSeparador +
					@aTipoPercepcion	+ @aSeparador +
					@aCodCM
					
				
RETURN ISNULL(@Retorno, '                                                                                                                                           ')
END
/*

SELECT dbo.CF_Percep_IIBB_Entrerios_TX(180314,'PERC.I.BRE', 17) 
00017,102,A,000000005091,30541519218,30/03/2023,-82555.33 ,0.50,-339.73   ,001,908                                                          
*/
                                                                                                                               